//Modifications for the Mobile Abilities Package are done and created by Peoharen.
using System;
using Server;
using Server.Items;
using System.Collections;
using System.Collections.Generic;

namespace Server.Mobiles
{
	//[CorpseName( "a FirePhoenix corpse" )]
	public class FirePhoenix : BaseCreature
	{
		private DateTime m_Delay = DateTime.Now;
		private bool m_Resurrected = false;
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.BleedAttack;
		}

		[Constructable]
		public FirePhoenix() : this ( false )
		{
		}

		[Constructable]
		public FirePhoenix( bool ress ) : base( AIType.AI_Mage, FightMode.Aggressor, 10, 1, 0.2, 0.3 )
		{
			Name = "a phoenix";
			Body = 5;
			Hue = Regions.FireRegion.RandomFireHue;
			EmoteHue = Utility.RandomDyedHue();
			BaseSoundID = 0x8F;
			
			m_Resurrected = ress;

			SetStr( 504, 700 );
			SetDex( 202, 300 );
			SetInt( 504, 700 );

			SetHits( (m_Resurrected) ? 1000 : 1500 );

			SetDamage( 25 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Fire, 60 );

			SetResistance( ResistanceType.Physical, 65, 75 );
			SetResistance( ResistanceType.Cold, 50 );
			SetResistance( ResistanceType.Fire, 100 );
			SetResistance( ResistanceType.Poison, 55, 75 );
			SetResistance( ResistanceType.Energy, 50, 65 );

			SetSkill( SkillName.EvalInt, 100.2, 150.0 );
			SetSkill( SkillName.Magery, 100.2, 120.0 );
			SetSkill( SkillName.Meditation, 75.1, 100.0 );
			SetSkill( SkillName.MagicResist, 86.0, 135.0 );
			SetSkill( SkillName.Tactics, 100.1, 120.0 );
			SetSkill( SkillName.Wrestling, 90.1, 120.0 );

			Fame = 15000;
			Karma = 0;

			VirtualArmor = 60;
		}
		
		public override bool OnBeforeDeath()
		{
			if ( !m_Resurrected )
			{
				FirePhoenix newPhoenix = new FirePhoenix( true );				
    
    			if ( newPhoenix != null )
    			{
    				Container pack = this.Backpack;
    				
               if (  pack != null )
    				{
                 for ( int i = pack.Items.Count - 1; i >= 0; --i )
      				{
      					if ( i >= pack.Items.Count )
      						continue;
      
      					newPhoenix.PackItem( pack.Items[i] );
      				}
               }

               newPhoenix.Hue = this.Hue;
               newPhoenix.Name = this.Name;
               newPhoenix.IsTeragon = this.IsTeragon;
               newPhoenix.IsParagon = this.IsParagon;
               
               Timer.DelayCall( TimeSpan.FromSeconds(6.0), new TimerStateCallback(RespawnPhoenix), new object[]{ newPhoenix , this.Location, this.Map } );
    			}
         }
			
			return base.OnBeforeDeath();
		}
		
		public static void RespawnPhoenix( object state )
		{
			object[] args = (object[])state;
			FirePhoenix fenix = (FirePhoenix) args[0];

			if ( fenix != null )
			{
				fenix.MoveToWorld( (Point3D) args[1], (Map) args[2] );
				fenix.Home = fenix.Location;
				// 				fenix.FixedParticles( 0x3709, 9, 20, 5049, EffectLayer.LeftFoot );
				// 				fenix.PlaySound( 0x5C3 );
				
				Effects.SendLocationParticles( EffectItem.Create( fenix.Location, fenix.Map, EffectItem.DefaultDuration ), 0, 0, 0, 0, 0, 5060, 0 );
				Effects.PlaySound( fenix.Location, fenix.Map, 0x5C3 );

				Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( fenix.X - 6, fenix.Y - 6, fenix.Z + 15 ), fenix.Map ), fenix, 0x36D4, 7, 0, false, true, fenix.Hue, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );
				Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( fenix.X - 4, fenix.Y - 6, fenix.Z + 15 ), fenix.Map ), fenix, 0x36D4, 7, 0, false, true, fenix.Hue, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );
				Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( fenix.X - 6, fenix.Y - 4, fenix.Z + 15 ), fenix.Map ), fenix, 0x36D4, 7, 0, false, true, fenix.Hue, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );

				Effects.SendTargetParticles( fenix, 0x375A, 35, 90, fenix.Hue, 0x00, 9502, (EffectLayer)255, 0x100 );
				fenix.Emote( "*Fenix povstal z popela*" );
			}
		}

		public override void GenerateLoot(bool spawning)
		{
			if ( m_Resurrected )
			{
				base.GenerateLoot(spawning);
				AddLoot( LootPack.UltraRich );
			}
		}
		
		public override void OnKilledBy( Mobile mob )
		{
			if ( m_Resurrected )
            base.OnKilledBy( mob );
		}
		
      public override void OnDeath(Container c)
      {
         if ( m_Resurrected )
            base.OnDeath(c);
         else
         {
            Server.Spells.Spellweaving.EssenceOfWindSpell.StopDebuffing(this, false);
            Server.Spells.Spellweaving.ThunderstormSpell.StopDebuffing(this, false);
             
            int sound = this.GetDeathSound();
    
    			if( sound >= 0 )
    				Effects.PlaySound( this, this.Map, sound );
    
    			if( !this.Player )
    			{
    				Delete();
    			}
         }            
      }

		public override int Meat{ get{ return 1; } }
		public override MeatType MeatType{ get{ return MeatType.Bird; } }
		public override int Feathers{ get{ return 45; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool IsNotScaredOfDeath{ get{ return Utility.RandomBool(); } } //neutika pri malem poctu hp - sance 50%
		public override bool HasBreath { get { return true; } } // breath enabled
		
		/*public override void OnThink()
		{
			if ( !m_Resurrected && DateTime.Now > m_Delay )
			{
				Ability.Aura( this, 50, 80, 1, 5, 0, "The hot air scorches your skin" );
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 15 ) );
			}
			base.OnThink();
		}*/
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if (  DateTime.Now > m_Delay )
			{
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 15, 30 ) );
				// Effects
				Effects.PlaySound( this.Location, this.Map, 0x5CA );
				ZoogiVejce.EffectCircle( this.Location, this.Map, 6, 0x3709 );
				
				ArrayList targets = Utilitky.GetTargets( this, 6, true );
				
				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if ( m == null || m.Deleted )
						continue;

					m.RevealingAction();
					m.PlaySound(0x208);
					m.FixedParticles(0x3709, 10, 30, 5052, EffectLayer.LeftFoot);
					
					int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage( Utility.RandomMinMax( 15, 30 ), m );
					
					if ( m is Xanthos.Interfaces.IEvoCreature )
						auradamage *= 2;
					
					m.Hits -= auradamage;
					ISTile5.SendDmgPacket( m, auradamage );
					
					if (m.Hits < 2)
						m.Kill();
				}
			}
		}

		public FirePhoenix( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
         if ( this.Map == Map.Internal )
			   this.Delete();
		}
	}
}
